/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.VI;

import com.quantumdata.VI.GenButtonHandler;
import com.quantumdata.VI.LcdDevice;
import com.quantumdata.VI.VIPanel;
import com.quantumdata.std.InstrumentNotificationHandler;
import com.quantumdata.std.InstrumentResponse;
import com.quantumdata.std.QDUtil;
import com.quantumdata.std.RemoteInstrument;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public class FrontPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLayeredPane m_buttonPane;
    private LcdDevice m_lcd;
    private JLabel[] m_btnLabels = new JLabel[7];
    private JButton[] m_grayButtons = new JButton[7];
    private Point[] m_labelCenter = new Point[7];
    private JLabel[] m_led = new JLabel[8];
    private int[] m_ledIds = new int[]{1, 4, 16, 64, 2, 8, 32, 128};
    private JLabel m_model882;
    private JLabel m_model881;
    private JLabel bBackground;
    private ImageIcon LEDonIcon;
    private ImageIcon LEDoffIcon;
    private ImageIcon buttonPadBlank;
    private ImageIcon[] m_enterIcons = new ImageIcon[2];
    private ImageIcon[] m_defaultGrayIcons = new ImageIcon[2];
    private final int ENTER_ID = 2;
    private RemoteInstrument m_instrument;
    private boolean m_basicMode;
    private Color m_browseColor = new Color(0, 0, 196);
    private final int m_glablcharw = 7;
    private final String[] m_basicLabels = new String[]{"Tools", "Settings", "Options", "Content", "Source", "Interface", "Sink"};
    private final String[] m_progLabels = new String[]{"Home", "Back", "Enter", "F1", "F2", "F3", "F4"};
    private final String[] m_basicTips = new String[]{"Tools Menu", "Settings Menu", "Options Menu", "Content Selection", "Source Selection", "Interface Selection", "Sink Selection"};
    private final String[] m_progTips = new String[]{"Return to the home menu", "Go back to the previous menu", "Enter a value (Context dependent)", "Programmable hotkey #1", "Programmable hotkey #2", "Programmable hotkey #3", "Programmable hotkey #4"};

    public void initialize(RemoteInstrument remoteInstrument) {
        GenButtonHandler genButtonHandler;
        JButton jButton;
        int n;
        this.m_instrument = remoteInstrument;
        this.LEDonIcon = QDUtil.createAppletImageIcon("images/LEDon.gif", VIPanel.class);
        this.LEDoffIcon = QDUtil.createAppletImageIcon("images/LEDoff.gif", VIPanel.class);
        this.buttonPadBlank = QDUtil.createAppletImageIcon("images/ButtonPadBlank.gif", VIPanel.class);
        this.m_defaultGrayIcons[0] = QDUtil.createAppletImageIcon("images/GrayButton.gif", VIPanel.class);
        this.m_defaultGrayIcons[1] = QDUtil.createAppletImageIcon("images/GrayButtonPress.gif", VIPanel.class);
        ImageIcon imageIcon = QDUtil.createAppletImageIcon("images/UpButton.gif", VIPanel.class);
        ImageIcon imageIcon2 = QDUtil.createAppletImageIcon("images/UpButtonPress.gif", VIPanel.class);
        ImageIcon imageIcon3 = QDUtil.createAppletImageIcon("images/DownButton.gif", VIPanel.class);
        ImageIcon imageIcon4 = QDUtil.createAppletImageIcon("images/DownButtonPress.gif", VIPanel.class);
        ImageIcon imageIcon5 = QDUtil.createAppletImageIcon("images/Spot.gif", VIPanel.class);
        ImageIcon imageIcon6 = QDUtil.createAppletImageIcon("images/SpotPress.gif", VIPanel.class);
        ImageIcon imageIcon7 = QDUtil.createAppletImageIcon("images/UUT.gif", VIPanel.class);
        ImageIcon imageIcon8 = QDUtil.createAppletImageIcon("images/uutPress.gif", VIPanel.class);
        imageIcon5 = QDUtil.createAppletImageIcon("images/Spot.gif", VIPanel.class);
        imageIcon6 = QDUtil.createAppletImageIcon("images/SpotPress.gif", VIPanel.class);
        ImageIcon imageIcon9 = QDUtil.createAppletImageIcon("images/User.gif", VIPanel.class);
        ImageIcon imageIcon10 = QDUtil.createAppletImageIcon("images/userPress.gif", VIPanel.class);
        ImageIcon imageIcon11 = QDUtil.createAppletImageIcon("images/hold.gif", VIPanel.class);
        ImageIcon imageIcon12 = QDUtil.createAppletImageIcon("images/holdPress.gif", VIPanel.class);
        this.m_enterIcons[0] = QDUtil.createAppletImageIcon("images/EnterButton.gif", VIPanel.class);
        this.m_enterIcons[1] = QDUtil.createAppletImageIcon("images/EnterButtonPress.gif", VIPanel.class);
        ImageIcon imageIcon13 = QDUtil.createAppletImageIcon("images/Model882.gif", VIPanel.class);
        ImageIcon imageIcon14 = QDUtil.createAppletImageIcon("images/Model881.gif", VIPanel.class);
        this.bBackground = new JLabel(this.buttonPadBlank);
        this.bBackground.setOpaque(true);
        this.bBackground.setSize(this.buttonPadBlank.getIconWidth(), this.buttonPadBlank.getIconHeight());
        this.m_buttonPane = new JLayeredPane();
        this.m_buttonPane.setPreferredSize(this.bBackground.getSize());
        this.m_buttonPane.setBackground(Color.black);
        this.m_buttonPane.add((Component)this.bBackground, JLayeredPane.DEFAULT_LAYER);
        this.m_model882 = new JLabel(imageIcon13);
        this.m_model882.setOpaque(true);
        this.m_model881 = new JLabel(imageIcon14);
        this.m_model881.setOpaque(true);
        Dimension dimension = new Dimension(this.m_defaultGrayIcons[0].getIconWidth(), this.m_defaultGrayIcons[0].getIconHeight());
        Dimension dimension2 = new Dimension(80, 10);
        Point point = new Point(40, 120);
        Point point2 = new Point(point);
        Font font = new Font("SansSerif", 1, 12);
        int[] nArray = new int[]{9, 11, 13, 8, 10, 12, 14};
        this.m_basicMode = true;
        point2.translate(33, 0);
        for (n = 0; n < 7; ++n) {
            jButton = new JButton(this.m_defaultGrayIcons[0]);
            jButton.setPressedIcon(this.m_defaultGrayIcons[1]);
            jButton.setFocusPainted(false);
            jButton.setBorderPainted(false);
            jButton.setContentAreaFilled(false);
            jButton.setSize(dimension);
            jButton.setEnabled(true);
            jButton.setMargin(new Insets(0, 0, 0, 0));
            jButton.setToolTipText(this.m_basicTips[n]);
            jButton.setLocation(point2);
            genButtonHandler = new GenButtonHandler(this.m_instrument, nArray[n]);
            jButton.setMnemonic(113 + n);
            jButton.addActionListener(genButtonHandler);
            jButton.addMouseListener(genButtonHandler);
            this.m_grayButtons[n] = jButton;
            this.m_buttonPane.add((Component)jButton, JLayeredPane.PALETTE_LAYER);
            this.m_btnLabels[n] = new JLabel(this.m_basicLabels[n]);
            this.m_btnLabels[n].setFont(font);
            this.m_btnLabels[n].setForeground(Color.black);
            this.m_btnLabels[n].setSize(dimension2);
            this.m_labelCenter[n] = new Point(point2.x + dimension.width / 2, point2.y - 5);
            this.m_btnLabels[n].setLocation(this.m_labelCenter[n].x - this.m_basicLabels[n].length() / 2 * 7, this.m_labelCenter[n].y);
            this.m_buttonPane.add((Component)this.m_btnLabels[n], JLayeredPane.PALETTE_LAYER);
            if (n == 2) {
                point2.setLocation(point);
                point2.translate(0, 60);
                continue;
            }
            point2.translate(67, 0);
        }
        this.m_grayButtons[2].setIcon(this.m_enterIcons[0]);
        this.m_grayButtons[2].setPressedIcon(this.m_enterIcons[1]);
        Dimension dimension3 = new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight());
        Dimension dimension4 = new Dimension(imageIcon3.getIconWidth(), imageIcon3.getIconHeight());
        Point point3 = new Point(point);
        point3.translate(268, 30);
        jButton = new JButton(imageIcon);
        jButton.setPressedIcon(imageIcon2);
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setEnabled(true);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setSize(dimension3);
        point2.setLocation(point3);
        point2.translate(0, -25);
        jButton.setLocation(point2);
        jButton.setToolTipText("Display pevious page or increment");
        genButtonHandler = new GenButtonHandler(this.m_instrument, 15);
        jButton.setMnemonic(38);
        jButton.addActionListener(genButtonHandler);
        jButton.addMouseListener(genButtonHandler);
        this.m_buttonPane.add((Component)jButton, JLayeredPane.PALETTE_LAYER);
        jButton = new JButton(imageIcon3);
        jButton.setPressedIcon(imageIcon4);
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setEnabled(true);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setSize(dimension4);
        point2.setLocation(point3);
        point2.translate(0, 25);
        jButton.setLocation(point2);
        jButton.setToolTipText("Display next page or decrement");
        genButtonHandler = new GenButtonHandler(this.m_instrument, 16);
        jButton.setMnemonic(40);
        jButton.addActionListener(genButtonHandler);
        jButton.addMouseListener(genButtonHandler);
        this.m_buttonPane.add((Component)jButton, JLayeredPane.PALETTE_LAYER);
        Dimension dimension5 = new Dimension(imageIcon5.getIconWidth(), imageIcon5.getIconHeight());
        jButton = new JButton(imageIcon5);
        jButton.setPressedIcon(imageIcon6);
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setSize(dimension5);
        jButton.setEnabled(true);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setToolTipText("Press to spot");
        jButton.setLocation(point3.x + dimension4.width - 15, point3.y - 10);
        genButtonHandler = new GenButtonHandler(this.m_instrument, 1026);
        jButton.addActionListener(genButtonHandler);
        jButton.addMouseListener(genButtonHandler);
        this.m_buttonPane.add((Component)jButton, JLayeredPane.PALETTE_LAYER);
        dimension5 = new Dimension(imageIcon9.getIconWidth(), imageIcon9.getIconHeight());
        jButton = new JButton(imageIcon9);
        jButton.setPressedIcon(imageIcon10);
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setSize(dimension5);
        jButton.setEnabled(true);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setToolTipText("Press for User Administration");
        point2.setLocation(point);
        point2.translate(67, 60 + dimension.height - 10);
        point2.translate(-(67 - dimension.width) / 2, 0);
        point2.translate(-dimension5.width / 2, 0);
        jButton.setLocation(point2);
        genButtonHandler = new GenButtonHandler(this.m_instrument, 1025);
        jButton.addActionListener(genButtonHandler);
        jButton.addMouseListener(genButtonHandler);
        this.m_buttonPane.add((Component)jButton, JLayeredPane.PALETTE_LAYER);
        dimension5 = new Dimension(imageIcon7.getIconWidth(), imageIcon7.getIconHeight());
        jButton = new JButton(imageIcon7);
        jButton.setPressedIcon(imageIcon8);
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setSize(dimension5);
        jButton.setEnabled(true);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setToolTipText("Press to select Unit Under Test");
        point2.setLocation(point);
        point2.translate(201, 60 + dimension.height - 10);
        point2.translate(-(67 - dimension.width) / 2, 0);
        point2.translate(-dimension5.width / 2, 0);
        jButton.setLocation(point2);
        genButtonHandler = new GenButtonHandler(this.m_instrument, 1024);
        jButton.addActionListener(genButtonHandler);
        jButton.addMouseListener(genButtonHandler);
        this.m_buttonPane.add((Component)jButton, JLayeredPane.PALETTE_LAYER);
        point2.translate(125, 14);
        this.m_model881.setLocation(point2);
        this.m_model882.setLocation(point2);
        this.m_buttonPane.add((Component)this.m_model881, JLayeredPane.PALETTE_LAYER);
        this.m_buttonPane.add((Component)this.m_model882, JLayeredPane.PALETTE_LAYER);
        this.m_model881.setSize(imageIcon14.getIconWidth(), imageIcon14.getIconHeight());
        this.m_model882.setSize(imageIcon13.getIconWidth(), imageIcon13.getIconHeight());
        this.m_model881.setVisible(false);
        this.m_model882.setVisible(false);
        Dimension dimension6 = new Dimension(this.LEDoffIcon.getIconWidth(), this.LEDoffIcon.getIconHeight());
        dimension5 = new Dimension(80, 10);
        Point point4 = new Point(55, 68);
        Font font2 = new Font("SansSerif", 0, 10);
        String[] stringArray = new String[]{"NETWORK", "D'VIDEO", "P'VIDEO", "C'DIFFERENCE", "BROWSE", "MULTI-LINK", "DATA", "PROTECTED"};
        point2.setLocation(point4);
        for (n = 0; n < 8; ++n) {
            this.m_led[n] = new JLabel(this.LEDoffIcon);
            this.m_led[n].setSize(dimension6);
            this.m_led[n].setLocation(point2);
            JLabel jLabel = new JLabel(stringArray[n]);
            jLabel.setSize(dimension5);
            jLabel.setFont(font2);
            jLabel.setLocation(point2.x + dimension6.width / 2 - stringArray[n].length() / 2 * 6, point2.y - 5);
            if (n != 4) {
                jLabel.setForeground(Color.black);
            } else {
                jLabel.setForeground(this.m_browseColor);
            }
            this.m_buttonPane.add((Component)this.m_led[n], JLayeredPane.PALETTE_LAYER);
            this.m_buttonPane.add((Component)jLabel, JLayeredPane.PALETTE_LAYER);
            if (n == 3) {
                point2.setLocation(point4);
                point2.translate(0, 26);
                continue;
            }
            point2.translate(84, 0);
        }
        dimension5 = new Dimension(imageIcon11.getIconWidth(), imageIcon11.getIconHeight());
        jButton = new JButton(imageIcon11);
        jButton.setPressedIcon(imageIcon12);
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setSize(dimension5);
        jButton.setEnabled(true);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setToolTipText("Press to Toggle Browse Mode");
        point2.setLocation(point4);
        point2.translate(0, 26);
        point2.translate(-16, 9);
        jButton.setLocation(point2);
        genButtonHandler = new GenButtonHandler(this.m_instrument, 265);
        jButton.addActionListener(genButtonHandler);
        jButton.addMouseListener(genButtonHandler);
        this.m_buttonPane.add((Component)jButton, JLayeredPane.PALETTE_LAYER);
        this.m_lcd = new LcdDevice();
        this.m_lcd.init(this.m_instrument);
        this.setLayout(new FlowLayout(0));
        this.add(this.m_lcd.getPane());
        this.add(this.m_buttonPane);
        this.m_instrument.addNotificationHandler(new InstrumentNotificationHandler(){
            private boolean m_busy = false;

            public void handleInstrumentNotification(String string) {
                if (!this.m_busy) {
                    this.m_busy = true;
                    if (string.equals("LCD-CHANGE")) {
                        FrontPanel.this.updateLcd();
                    } else if (string.equals("LED-CHANGE")) {
                        FrontPanel.this.updateLeds();
                    }
                    this.m_busy = false;
                }
            }
        });
    }

    public void updateLcd() {
        String string = "LCDS? 1";
        InstrumentResponse instrumentResponse = this.m_instrument.sendCmd(string);
        if (instrumentResponse.isError()) {
            return;
        }
        this.m_lcd.updateDisplay(instrumentResponse.getResponse());
    }

    public void updateLeds() {
        String string = "LEDS?";
        InstrumentResponse instrumentResponse = this.m_instrument.sendCmd(string);
        if (instrumentResponse.isError()) {
            return;
        }
        int n = Integer.parseInt(instrumentResponse.getResponse());
        for (int i = 0; i < 8; ++i) {
            Icon icon = this.m_led[i].getIcon();
            if ((n & this.m_ledIds[i]) != 0) {
                this.m_led[i].setIcon(this.LEDonIcon);
            } else {
                this.m_led[i].setIcon(this.LEDoffIcon);
            }
            if (i != 4 || icon == this.m_led[i].getIcon()) continue;
            this.ChangeMode(icon == this.LEDonIcon);
        }
    }

    private void ChangeMode(boolean bl) {
        if (this.m_basicMode == bl) {
            return;
        }
        this.m_basicMode = bl;
        if (this.m_basicMode) {
            for (int i = 0; i < 7; ++i) {
                this.m_grayButtons[i].setForeground(Color.black);
                this.m_grayButtons[i].setToolTipText(this.m_basicTips[i]);
                this.m_btnLabels[i].setForeground(Color.black);
                this.m_btnLabels[i].setText(this.m_basicLabels[i]);
                this.m_btnLabels[i].setLocation(this.m_labelCenter[i].x - this.m_basicLabels[i].length() / 2 * 7, this.m_labelCenter[i].y);
            }
            this.m_grayButtons[2].setIcon(this.m_enterIcons[0]);
            this.m_grayButtons[2].setPressedIcon(this.m_enterIcons[1]);
        } else {
            for (int i = 0; i < 7; ++i) {
                this.m_grayButtons[i].setToolTipText(this.m_progTips[i]);
                this.m_btnLabels[i].setForeground(this.m_browseColor);
                this.m_btnLabels[i].setText(this.m_progLabels[i]);
                this.m_btnLabels[i].setLocation(this.m_labelCenter[i].x - this.m_progLabels[i].length() / 2 * 7, this.m_labelCenter[i].y);
            }
            this.m_grayButtons[2].setIcon(this.m_defaultGrayIcons[0]);
            this.m_grayButtons[2].setPressedIcon(this.m_defaultGrayIcons[1]);
        }
    }

    public void setModel(String string) {
        this.m_model882.setVisible(false);
        this.m_model881.setVisible(false);
        if (string.compareTo("882") == 0) {
            this.m_model882.setVisible(true);
        } else if (string.compareTo("881") == 0) {
            this.m_model881.setVisible(true);
        }
    }
}

